function transliterate(str) {
    const map = {
        а: 'a',
        б: 'b',
        в: 'v',
        г: 'g',
        д: 'd',
        е: 'e',
        ё: 'e',
        ж: 'zh',
        з: 'z',
        и: 'i',
        й: 'y',
        к: 'k',
        л: 'l',
        м: 'm',
        н: 'n',
        о: 'o',
        п: 'p',
        р: 'r',
        с: 's',
        т: 't',
        у: 'u',
        ф: 'f',
        х: 'h',
        ц: 'ts',
        ч: 'ch',
        ш: 'sh',
        щ: 'shch',
        ы: 'y',
        э: 'e',
        ю: 'yu',
        я: 'ya',
    };

    return str
        .toLowerCase()
        .replace(/[ьъ]/g, '') // <-- просто исключаем мягкий и твёрдый знаки
        .split('')
        .map((char) => map[char] || char)
        .join('');
}

export function generateLogin(firstName, lastName) {
    const randomNum = Math.floor(Math.random() * 1000)
        .toString()
        .padStart(3, '0');

    const login = transliterate(firstName.trim()) + '.' + transliterate(lastName.trim()) + randomNum;
    return login;
}

export function generateTemporaryPassword(length = 10) {
    const charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let password = '';
    const randomValues = new Uint32Array(length);
    window.crypto.getRandomValues(randomValues);

    for (let i = 0; i < length; i++) {
        // Выбираем символ из charset по индексу из randomValues
        password += charset[randomValues[i] % charset.length];
    }

    return password;
}
