import { defineStore } from 'pinia';

export const useDisplayMapStore = defineStore('displayMap', {
    state: () => ({
        needRefreshMap: false,
        points: [],
    }),
    actions: {
        setPoints(points) {
            this.points = points;
        },
        triggerMapRefresh() {
            this.needRefreshMap = true;
        },
        resetMapRefresh() {
            this.needRefreshMap = false;
        },
    },
});