import { defineStore } from 'pinia'
import { ref }         from 'vue'
import { refService }  from '@/api/refService'

export const useRefStore = defineStore('ref', () => {

    /* ---------- state ---------- */
    const managersGroup    = ref([])
    const managersSubgroup = ref([])
    const districts        = ref([])

    /* ---------- actions -------- */
    async function loadManagers() {
        const [{ data: grp }, { data: sub }] = await Promise.all([
            refService.managers('group'),
            refService.managers('subgroup')
        ])
        managersGroup.value    = grp
        managersSubgroup.value = sub
    }

    async function loadDistricts() {
        const { data } = await refService.districts()
        districts.value = data
    }

    /** единый публичный метод — вызываем из компонента */
    async function init() {
        await Promise.all([loadManagers(), loadDistricts()])
    }

    return {
        /* state */
        managersGroup, managersSubgroup, districts,
        /* methods */
        init,
    }
})