import { defineStore } from 'pinia';
import { authService } from '@/api/authService';

export const useNotificationStore = defineStore('notifications', {
    state: () => ({
        notifications: [],
    }),
    getters: {
        unreadCount(state) {
            return state.notifications.filter(n => !n.is_read).length;
        },
    },
    actions: {
        async fetchNotifications() {
            try {
                const res = await authService.getNotifications();
                this.notifications = res.data;
            } catch (e) {
                console.error('Ошибка при получении уведомлений', e);
            }
        },
        async markAsRead(id) {
            try {
                await authService.markNotificationAsRead(id);
                const notif = this.notifications.find(n => n.id === id);
                if (notif) notif.is_read = true;
            } catch (e) {
                console.error('Ошибка при отметке уведомления как прочитанного', e);
            }
        },
    },
});
